"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createRemoteRuntime = void 0;
const runtime_folder_1 = __importDefault(require("@postman/runtime.folder"));
const runtime_collection_1 = __importDefault(require("@postman/runtime.collection"));
const runtime_grpc_request_1 = __importDefault(require("@postman/runtime.grpc-request"));
const runtime_mqtt_request_1 = __importDefault(require("@postman/runtime.mqtt-request"));
const complete_runtime_1 = __importDefault(require("./complete-runtime"));
const runtime_websocket_request_1 = __importDefault(require("@postman/runtime.websocket-request"));
const runtime_socket_io_request_1 = __importDefault(require("@postman/runtime.socket.io-request"));
function createRemoteRuntime({ client, ...config }) {
    const runtime = new complete_runtime_1.default();
    runtime.registerType(runtime_folder_1.default.use());
    runtime.registerType(runtime_collection_1.default.use());
    runtime.registerExecutableType(runtime_grpc_request_1.default.use().implement({
        async invoke(options) {
            const { remote } = await client.invoke('grpc-request.invoke', options);
            remote.onCleanup((err) => err && remote.events.emit('error', err));
            return remote.toProxy(['end', 'cancel'], ['write']);
        },
        resolveSchema: config.grpcRequest?.resolveSchema || (() => { }),
    }));
    runtime.registerExecutableType(runtime_mqtt_request_1.default.use().implement({
        async connect(options) {
            const { remote } = await client.invoke('mqtt-request.connect', options);
            remote.onCleanup((err) => err && remote.events.emit('error', err));
            return remote.toProxy(['disconnect', 'cancel', 'publish', 'subscribe', 'unsubscribe'], []);
        },
    }));
    runtime.registerExecutableType(runtime_websocket_request_1.default.use().implement({
        async connect(options) {
            const { remote } = await client.invoke('websocket-request.connect', options);
            remote.onCleanup((err) => err && remote.events.emit('error', err));
            return remote.toProxy(['close', 'send'], []);
        },
    }));
    runtime.registerExecutableType(runtime_socket_io_request_1.default.use().implement({
        async connect(options) {
            const { remote } = await client.invoke('socketio-request.connect', options);
            remote.onCleanup((err) => err && remote.events.emit('error', err));
            return remote.toProxy(['disconnect', 'publish', 'subscribe', 'unsubscribe'], []);
        },
    }));
    return runtime;
}
exports.createRemoteRuntime = createRemoteRuntime;
//# sourceMappingURL=remote-runtime.js.map