export interface HTTPRequest {
    method: 'GET' | 'CONNECT';
    href: string;
    headers: Array<{
        key: string;
        value: string;
    }>;
    httpVersion: string;
}
export interface HTTPResponse {
    statusCode: number;
    statusMessage: string;
    headers: Array<{
        key: string;
        value: string;
    }>;
    httpVersion: string;
}
export interface ConnectionEndEvent {
    reason?: string;
    aborted: boolean;
}
export interface ErrorEvent {
    error: {
        message: string;
    };
    handshakeRequest?: HTTPRequest;
    handshakeResponse?: HTTPResponse;
}
export interface MessageEvent {
    messages: Array<string | Uint8Array>;
    eventName: string;
}
export interface OpenEvent {
    request?: HTTPRequest;
    response?: HTTPResponse;
}
export interface ReconnectEvent {
    attempt: number;
    timeout: number;
}
export interface CloseEvent {
    reason: string;
}
export interface SubscribeEvent {
    event: string;
}
export interface UnsubscribeEvent {
    event: string;
}
