"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Connection = void 0;
const runtime_mqtt_utils_1 = require("@postman/runtime.mqtt-utils");
const events_1 = require("events");
const mqtt = __importStar(require("mqtt/dist/mqtt"));
const utilities_1 = require("./utilities");
const RECONNECT_ATTEMPTS_LIMIT = 3;
/*
    Connection represents an active MQTT connection to a broker. It is responsible
    for maintaining the underlying TCP socket or websocket, and for dispatching events to the
    appropriate handlers.

    The connection returns a stream to the consumer that listens for calls from the consumer
    and emits client events.
*/
class Connection extends events_1.EventEmitter {
    constructor(client) {
        super();
        this.reconnectCount = 0;
        this.client = client;
        this.client
            .on('packetreceive', (packet) => {
            this.emit('incoming-packet', (0, runtime_mqtt_utils_1.parsePacket)(packet));
        })
            .on('packetsend', (packet) => {
            this.emit('outgoing-packet', (0, runtime_mqtt_utils_1.parsePacket)(packet));
        })
            .on('error', (err) => {
            // Error with reason code is an error code in an MQTT packet.
            if (err instanceof mqtt.ErrorWithReasonCode) {
                // Currently two events will be emitted for this error.
                // A packetreceive event with the packet and an mqtt-error event with the error.
                this.emit('mqtt-error', err);
            }
            else {
                this.emit('error', err);
            }
        })
            .on('reconnect', () => {
            if (this.reconnectCount >= RECONNECT_ATTEMPTS_LIMIT) {
                this.client.end();
                return;
            }
            this.reconnectCount++;
            this.emit('reconnect', this.reconnectCount);
        })
            .on('connect', () => {
            // The 'packetreceive' event will handle sending the relevant information to the consumer.
            // Might change this in the future for a bit more control and error handling.
            // Reconnected connections will receive another connack packet, so we need to reset the count.
            this.reconnectCount = 0;
        })
            .on('close', () => {
            this.emit('close');
        });
        this.client.connect();
    }
    publish(topic, message, options) {
        if (!topic || topic === '') {
            throw new Error('Topic is required');
        }
        // Transform options to mqtt publish options
        const publishOptions = {
            qos: options.qos,
            retain: options.retain,
        };
        if (options.properties) {
            const { userProperties, correlationData, ...properties } = options.properties;
            const clientProperties = properties;
            if (correlationData) {
                clientProperties.correlationData = Buffer.from(correlationData);
            }
            if (userProperties) {
                clientProperties.userProperties =
                    (0, utilities_1.transformUserProperties)(userProperties);
            }
            publishOptions.properties = clientProperties;
        }
        this.client.publish(topic, message, publishOptions);
    }
    subscribe(topic, options) {
        const { qos = 0, settings, userProperties } = options;
        const { noLocal: nl, retainAsPublished: rap, retainHandling: rh, subscriptionIdentifier, } = settings ?? {};
        const subscribeOptions = { qos, nl, rap, rh };
        if (userProperties) {
            const transformedUserProperties = (0, utilities_1.transformUserProperties)(userProperties);
            if (Object.keys(transformedUserProperties).length > 0) {
                subscribeOptions.properties = {
                    ...subscribeOptions.properties,
                    userProperties: transformedUserProperties,
                };
            }
        }
        if (subscriptionIdentifier) {
            subscribeOptions.properties = {
                ...subscribeOptions.properties,
                subscriptionIdentifier,
            };
        }
        this.client.subscribe(topic, JSON.parse(JSON.stringify(subscribeOptions)));
    }
    unsubscribe(topic) {
        this.client.unsubscribe(topic);
    }
    disconnect(force = false, options) {
        this.client.end(force, options);
    }
    getClient() {
        return this.client;
    }
    isConnected() {
        return this.client.connected;
    }
}
exports.Connection = Connection;
//# sourceMappingURL=connection.js.map