"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.GRPCEvents = void 0;
const json_schema_to_ts_1 = require("json-schema-to-ts");
const runtime_core_1 = require("@postman/runtime.core");
const runtime_documentation_1 = __importDefault(require("@postman/runtime.documentation"));
const runtime_variables_1 = __importDefault(require("@postman/runtime.variables"));
const runtime_schema_1 = __importDefault(require("@postman/runtime.schema"));
const runtime_auth_1 = __importDefault(require("@postman/runtime.auth"));
const runtime_events_1 = __importDefault(require("@postman/runtime.events"));
const handler_1 = __importDefault(require("./handler"));
const auth_1 = __importDefault(require("./extensions/auth"));
const events_1 = __importDefault(require("./extensions/events"));
const variables_1 = __importDefault(require("./extensions/variables"));
exports.GRPCEvents = __importStar(require("./events"));
__exportStar(require("./agent"), exports);
const definition = (0, json_schema_to_ts_1.asConst)({
    name: 'grpc-request',
    summary: 'gRPC Request',
    schema: {
        type: 'object',
        required: ['url', 'methodPath', 'message', 'metadata'],
        properties: {
            url: {
                type: 'string',
            },
            methodPath: {
                type: 'string',
            },
            methodDescriptor: {
                type: 'string',
            },
            message: {
                type: 'object',
                required: ['content'],
                properties: {
                    content: {
                        type: 'string',
                    },
                },
                additionalProperties: false,
            },
            metadata: {
                type: 'array',
                items: {
                    type: 'object',
                    required: ['key', 'value'],
                    properties: {
                        key: {
                            type: 'string',
                        },
                        value: {
                            type: 'string',
                        },
                        description: {
                            type: 'string',
                        },
                        disabled: {
                            type: 'boolean',
                        },
                    },
                    additionalProperties: false,
                },
            },
            settings: {
                type: 'object',
                properties: {
                    secureConnection: {
                        type: 'boolean',
                    },
                    strictSSL: {
                        type: 'boolean',
                    },
                    serverNameOverride: {
                        type: 'string',
                    },
                    maxResponseMessageSize: {
                        type: 'number',
                    },
                    includeDefaultFields: {
                        type: 'boolean',
                    },
                    connectionTimeout: {
                        type: 'number',
                    },
                },
                additionalProperties: false,
            },
        },
        additionalProperties: false,
    },
    constraints: [
        {
            constraint: 'allow-child-types',
            allowed: ['grpc-example'],
        },
        {
            constraint: 'allow-extensions',
            allowed: ['auth', 'schema', 'events', 'documentation', 'variables'],
        },
    ],
});
const extensions = [
    runtime_documentation_1.default.use().implement({}),
    runtime_schema_1.default.use().implement({}),
    runtime_events_1.default.use().implement(events_1.default),
    runtime_variables_1.default.use().implement(variables_1.default),
    runtime_auth_1.default.use().implement(auth_1.default),
];
var GRPCRequest;
(function (GRPCRequest) {
    GRPCRequest.use = runtime_core_1.ItemType.define(definition, extensions, handler_1.default);
})(GRPCRequest || (GRPCRequest = {}));
exports.default = GRPCRequest;
//# sourceMappingURL=index.js.map