import { Item, Event } from '@postman/runtime.core';
import Auth from '@postman/runtime.auth';
declare const _default: (prevContext: Partial<{
    request: Partial<{
        id: string;
        name: string;
        url: string;
        auth: Auth.Data;
        metadata: {
            key: string;
            value: string;
        }[];
        methodPath: string;
        messages: {
            data: Record<string, any>;
            timestamp?: string;
        }[];
    }>;
    response: Partial<{
        responseTime: number;
        statusCode: number;
        metadata: {
            key: string;
            value: string;
        }[];
        trailers: {
            key: string;
            value: string;
        }[];
        messages: {
            data: Record<string, any>;
            timestamp: string;
        }[];
    }>;
}> | undefined, item: Item, event?: Event) => {
    request: {
        id?: string | undefined;
        name?: string | undefined;
        url?: string | undefined;
        auth?: {
            awsv4?: {
                key: string;
                value: unknown;
            }[] | undefined;
            basic?: {
                key: string;
                value: unknown;
            }[] | undefined;
            bearer?: {
                key: string;
                value: unknown;
            }[] | undefined;
            hawk?: {
                key: string;
                value: unknown;
            }[] | undefined;
            oauth1?: {
                key: string;
                value: unknown;
            }[] | undefined;
            oauth2?: {
                key: string;
                value: unknown;
            }[] | undefined;
            apikey?: {
                key: string;
                value: unknown;
            }[] | undefined;
            edgegrid?: {
                key: string;
                value: unknown;
            }[] | undefined;
            type: "awsv4" | "basic" | "bearer" | "hawk" | "oauth1" | "oauth2" | "apikey" | "edgegrid" | "noauth";
        } | undefined;
        metadata?: {
            key: string;
            value: string;
        }[] | undefined;
        methodPath?: string | undefined;
        messages?: {
            data: Record<string, any>;
            timestamp?: string | undefined;
        }[] | undefined;
    };
    response: {
        responseTime?: number | undefined;
        statusCode?: number | undefined;
        metadata?: {
            key: string;
            value: string;
        }[] | undefined;
        trailers?: {
            key: string;
            value: string;
        }[] | undefined;
        messages?: {
            data: Record<string, any>;
            timestamp: string;
        }[] | undefined;
    };
};
export default _default;
