/// <reference path="../../src/sandbox/types.d.ts" />
import type { ExecutionContext } from 'postman-sandbox';
import { Event, STOP_RUN } from '@postman/runtime.core';
export type ItemContext = Pick<ExecutionContext, 'request' | 'response'>;
export interface SentEvent {
    data: unknown;
    source: {
        id: string;
        name?: string;
    };
    [STOP_RUN]?: boolean;
}
export type HTTPResponseEvent = Event<'extension:events:http-response', {
    id: string;
    eventId: string;
    err: unknown;
    response: unknown;
}>;
