"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Runtime = void 0;
const runtime_variable_scope_1 = require("@postman/runtime.variable-scope");
const item_1 = __importDefault(require("./item"));
const item_tree_1 = __importDefault(require("./item-tree"));
const validator_1 = require("./validator");
const run_1 = __importStar(require("./run"));
/*
    A Runtime is a subclass of Validator which is also capable of executing
    Items (and trees of Items). Instead of registering ItemTypes (as done in
    Validator), you provide an *implementation* of each ItemType that you want
    to execute.
*/
class Runtime extends validator_1.Validator {
    constructor() {
        super(...arguments);
        this[_a] = new Map();
    }
    registerExecutableType(impl) {
        super.registerType(impl.itemType);
        this[run_1.impls].set(impl.itemType.name, impl);
        return this;
    }
    execItem(item, options) {
        item = cloneAsJSON(item);
        if (!item_1.default.isItem(item)) {
            throw new TypeError('Invalid Item');
        }
        const context = getRuntimeContext(item, options);
        return new run_1.default(this, context, [item], Boolean(options?.startPaused));
    }
    execTree(tree, options) {
        tree = cloneAsJSON(tree);
        if (!item_tree_1.default.isItemTree(tree)) {
            throw new TypeError('Invalid ItemTree');
        }
        const context = getRuntimeContext(tree.item, options);
        return new run_1.default(this, context, item_tree_1.default.toItems(item_tree_1.default.toResolved(tree)), Boolean(options?.startPaused));
    }
}
exports.Runtime = Runtime;
_a = run_1.impls;
function cloneAsJSON(value) {
    const json = JSON.stringify(value);
    if (json !== undefined) {
        return JSON.parse(json);
    }
    return value;
}
function getVariableScope(variables) {
    return new runtime_variable_scope_1.VariableScope(variables
        ? Array.isArray(variables)
            ? { values: variables }
            : variables
        : { values: [] });
}
function getCollectionVariables(item) {
    const payload = item.payload;
    return getVariableScope(item.type === 'collection'
        ? payload?.variables
        : undefined);
}
function getRuntimeContext(item, options) {
    const locals = getVariableScope(options?.variables?.locals);
    const defaultVariables = getVariableScope(options?.variables?.defaults);
    const collectionVariables = getCollectionVariables(item);
    const environment = getVariableScope(options?.variables?.environment);
    const globals = getVariableScope(options?.variables?.globals);
    const variables = new runtime_variable_scope_1.Variables(locals, 
    // TODO: add data variables here
    environment, collectionVariables, globals, defaultVariables);
    return {
        variables,
        locals,
        collectionVariables,
        environment,
        globals,
        secureContext: options?.secureContext,
        proxy: options?.proxy,
    };
}
//# sourceMappingURL=runtime.js.map