import { type EventChannel } from '@postman/runtime.event-channel';
import { Variables, VariableScope } from '@postman/runtime.variable-scope';
import Item from './item';
import ItemTree from './item-tree';
import ItemType from './item-type';
import { Validator } from './validator';
import Run, { impls } from './run';
export declare class Runtime extends Validator {
    private readonly [impls];
    registerExecutableType(impl: ItemType.Implementation): this;
    execItem<Y extends ItemType = ItemType>(item: Item.OfType<Y>, options?: RuntimeOptions): Run;
    execTree(tree: ItemTree, options?: RuntimeOptions): Run;
}
export interface RuntimeContextCore {
    variables: Variables;
    locals: VariableScope;
    collectionVariables: VariableScope;
    environment: VariableScope;
    globals: VariableScope;
    secureContext: RuntimeOptions['secureContext'];
    proxy: RuntimeOptions['proxy'];
}
export interface RuntimeContext extends RuntimeContextCore {
    events: EventChannel.Any;
}
export interface RuntimeOptions {
    variables?: VariableOptions;
    secureContext?: ((url: string) => Promise<SecureContextOptions> | SecureContextOptions) | SecureContextOptions;
    proxy?: ((url: string, isSecure?: boolean) => Promise<ProxyOptions> | ProxyOptions) | ProxyOptions;
    startPaused?: boolean;
}
export interface VariableOptions {
    environment?: VariableScope.Definition | VariableScope.Values;
    globals?: VariableScope.Definition | VariableScope.Values;
    defaults?: VariableScope.Definition | VariableScope.Values;
    locals?: VariableScope.Definition | VariableScope.Values;
}
export interface ProxyOptions {
    url?: string;
    ignoreEnvironmentVariables?: boolean;
}
export interface SecureContextOptions {
    ca?: string | string[];
    crl?: string | string[];
    cert?: string | string[];
    key?: string | (string | KeyObject)[];
    pfx?: string | (string | PxfObject)[];
    passphrase?: string;
}
export interface KeyObject {
    pem: string;
    passphrase?: string;
}
export interface PxfObject {
    buf: string;
    passphrase?: string;
}
