source "${0%/*}/color_util.sh"

FAILED_TESTS=0
PASSED_TESTS=0

function _catch_error() {
  local lastReturnCode="$?"
  local caller_function="${FUNCNAME[1]}"
  if [ "$lastReturnCode" != 0 ]; then
    FAILED_TESTS=$((FAILED_TESTS + 1))
    echo -e "$RED ${FAILED_TESTS}) $caller_function $WHITE"
  else
    PASSED_TESTS=$((PASSED_TESTS + 1))
    echo -e "$GREEN ✓ $caller_function $WHITE"
  fi
}

function should_fail_for_no_arguments () {
  local expected_output="InvalidArgumentException: Hermes~swap_and_relaunch packageName, eID, rootDirectory, parentProcessID and restart are the required parameters"
  test "`${0%/*}/../../../src/swap_and_relaunch.sh`" == "$expected_output"
  _catch_error
}

function should_fail_for_one_argument () {
  local expected_output="InvalidArgumentException: Hermes~swap_and_relaunch packageName, eID, rootDirectory, parentProcessID and restart are the required parameters"
  test "`${0%/*}/../../../src/swap_and_relaunch.sh packageName`" == "$expected_output"
  _catch_error
}

function should_open_the_application_with_arguments () {
  local testDir="`pwd`/tests"

  # create a .tmp directory in tests and copy the sample application
  rm -rf "$testDir/.tmp"
  mkdir "$testDir/.tmp"
  cp -R "$testDir/assets/sample-application" "$testDir/.tmp/sample"

  local expected_output="new app --updated --eID=sample-1234"
  `pwd`/src/swap_and_relaunch.sh sample sample-1234 `pwd`/tests/.tmp/sample 0 true 2>&1

  local output=`cat "$testDir/.tmp/logs.txt"`
  test "$output" == "$expected_output"
  _catch_error

  # cleanup
  rm -rf "$testDir/.tmp"
}

function should_open_the_application_with_argument_restart_undefined () {
  local testDir="`pwd`/tests"

  # create a .tmp directory in tests and copy the sample application
  rm -rf "$testDir/.tmp"
  mkdir "$testDir/.tmp"
  cp -R "$testDir/assets/sample-application" "$testDir/.tmp/sample"

  local expected_output="new app --updated --eID=sample-1234"
  `pwd`/src/swap_and_relaunch.sh sample sample-1234 `pwd`/tests/.tmp/sample 0 undefined 2>&1
  
  local output=`cat "$testDir/.tmp/logs.txt"`
  test "$output" == "$expected_output"
  _catch_error

  # cleanup
  rm -rf "$testDir/.tmp"
}

# Tests
echo "Swap And Relaunch"
should_fail_for_no_arguments
should_fail_for_one_argument
should_open_the_application_with_arguments
should_open_the_application_with_argument_restart_undefined

function should_skip_relaunch_with_argument_restart_false () {
  local testDir="`pwd`/tests"

  # create a .tmp directory in tests and copy the sample application
  rm -rf "$testDir/.tmp"
  mkdir "$testDir/.tmp"
  cp -R "$testDir/assets/sample-application" "$testDir/.tmp/sample"

  local expected_output="Relaunch~skipped"
  local output=$(`pwd`/src/swap_and_relaunch.sh sample sample-1234 `pwd`/tests/.tmp/sample 0 false 2>&1)

  test "$output" == "$expected_output"
  _catch_error

  # cleanup
  rm -rf "$testDir/.tmp"
}

echo "Swap but Skip Relaunch"
should_skip_relaunch_with_argument_restart_false

echo -e "\n$GREEN $PASSED_TESTS passing $WHITE"
if [ $FAILED_TESTS != 0 ]; then
  echo -e "$RED $FAILED_TESTS failing $WHITE"
  exit 1
fi
