import { InnerClient } from "./core.js";
import * as types from "./types.js";
import { SdkIterable } from "./iterator.js";
/**
 *  The Vaults API holds all the operations the SDK client can perform on 1Password vaults.
 */
export interface VaultsApi {
    /**
     *  List all vaults
     */
    listAll(): Promise<SdkIterable<types.VaultOverview>>;
}
export declare class VaultsSource implements VaultsApi {
    #private;
    constructor(inner: InnerClient);
    /**
     *  List all vaults
     */
    listAll(): Promise<SdkIterable<types.VaultOverview>>;
}
